/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.api.power;

import net.minecraft.class_1799;
import net.minecraft.class_2487;
import team.reborn.energy.*;

public final class ItemPowerHolder {

	private static boolean setup = false;

	public static void setup(){
		if(setup){
			return;
		}
		setup = true;
		Energy.registerHolder(object -> {
			if(object instanceof class_1799){
				return !((class_1799) object).method_7960() && ((class_1799) object).method_7909() instanceof EnergyHolder;
			}
			return false;
		}, object -> {
			final class_1799 stack = (class_1799) object;
			final EnergyHolder energyHolder = (EnergyHolder) stack.method_7909();
			return new EnergyStorage() {
				@Override
				public double getStored(EnergySide face) {
					validateNBT();
					return stack.method_7969().method_10574("energy");
				}

				@Override
				public void setStored(double amount) {
					validateNBT();
					stack.method_7969().method_10549("energy", amount);
				}

				@Override
				public double getMaxStoredPower() {
					return energyHolder.getMaxStoredPower();
				}

				@Override
				public EnergyTier getTier() {
					return energyHolder.getTier();
				}

				private void validateNBT() {
					if (!stack.method_7985()) {
						stack.method_7980(new class_2487());
						stack.method_7969().method_10569("energy", 0);
					}
				}
			};
		});
	}

}
