/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import reborncore.api.items.InventoryBase;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.util.IInventoryAccess;

public class RebornInventory<T extends MachineBaseBlockEntity>
extends InventoryBase {
    private final String name;
    private final int stackLimit;
    private T blockEntity;
    private boolean hasChanged = false;
    private final IInventoryAccess<T> inventoryAccess;

    public RebornInventory(int size, String invName, int invStackLimit, T blockEntity, IInventoryAccess<T> access) {
        super(size);
        this.name = invName;
        this.stackLimit = invStackLimit == 64 ? class_1802.field_8162.method_7882() : invStackLimit;
        this.blockEntity = blockEntity;
        this.inventoryAccess = access;
    }

    public RebornInventory(int size, String invName, int invStackLimit, T blockEntity) {
        this(size, invName, invStackLimit, (MachineBaseBlockEntity)blockEntity, (slotID, stack, facing, direction, be) -> {
            if (facing == null) {
                return true;
            }
            switch (direction) {
                case INSERT: {
                    return SlotConfiguration.canInsertItem(slotID, stack, facing, be);
                }
                case EXTRACT: {
                    return SlotConfiguration.canExtractItem(slotID, stack, facing, be);
                }
            }
            return false;
        });
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void method_5447(int slot, @Nonnull class_1799 stack) {
        super.method_5447(slot, stack);
        this.setChanged();
    }

    public class_1799 shrinkSlot(int slot, int count) {
        class_1799 stack = this.method_5438(slot);
        stack.method_7934(count);
        this.setChanged();
        return stack;
    }

    public RebornInventory getExternal(class_2350 facing) {
        throw new UnsupportedOperationException("needs fixing");
    }

    public void read(class_2487 data) {
        this.read(data, "Items");
    }

    public void read(class_2487 data, String tag) {
        class_2487 nbttaglist = data.method_10562(tag);
        this.deserializeNBT(nbttaglist);
        this.hasChanged = true;
    }

    public void write(class_2487 data) {
        this.write(data, "Items");
    }

    public void write(class_2487 data, String tag) {
        data.method_10566(tag, this.serializeNBT());
    }

    public int getContents() {
        int count = 0;
        for (class_1799 stack : this.getStacks()) {
            if (stack.method_7960()) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public T getBlockEntity() {
        return this.blockEntity;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setChanged() {
        this.hasChanged = true;
    }

    public void setChanged(boolean changed) {
        this.hasChanged = changed;
    }

    public void resetChanged() {
        this.hasChanged = false;
    }

    public int getStackLimit() {
        return this.stackLimit;
    }

    @Override
    public void method_5431() {
        super.method_5431();
        this.blockEntity.method_5431();
    }
}

