/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.screen.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_2586;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.client.screen.builder.BlockEntityScreenHandlerBuilder;
import reborncore.client.screen.builder.BuiltScreenHandler;
import reborncore.client.screen.builder.PlayerScreenHandlerBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;

public class ScreenHandlerBuilder {
    private final String name;
    private Predicate<class_1657> canInteract = player -> true;
    final List<class_1735> slots;
    final List<Range<Integer>> playerInventoryRanges;
    final List<Range<Integer>> blockEntityInventoryRanges;
    final List<Pair<Supplier, Consumer>> objectValues;
    final List<Consumer<class_1715>> craftEvents;

    public ScreenHandlerBuilder(String name) {
        this.name = name;
        this.slots = new ArrayList<class_1735>();
        this.playerInventoryRanges = new ArrayList<Range<Integer>>();
        this.blockEntityInventoryRanges = new ArrayList<Range<Integer>>();
        this.objectValues = new ArrayList<Pair<Supplier, Consumer>>();
        this.craftEvents = new ArrayList<Consumer<class_1715>>();
    }

    public ScreenHandlerBuilder interact(Predicate<class_1657> canInteract) {
        this.canInteract = canInteract;
        return this;
    }

    public PlayerScreenHandlerBuilder player(class_1661 player) {
        return new PlayerScreenHandlerBuilder(this, player);
    }

    public BlockEntityScreenHandlerBuilder blockEntity(class_2586 blockEntity) {
        return new BlockEntityScreenHandlerBuilder(this, blockEntity);
    }

    void addPlayerInventoryRange(Range<Integer> range) {
        this.playerInventoryRanges.add(range);
    }

    void addBlockEnityInventoryRange(Range<Integer> range) {
        this.blockEntityInventoryRanges.add(range);
    }

    @Deprecated
    public BuiltScreenHandler create(int syncID) {
        BuiltScreenHandler built = new BuiltScreenHandler(syncID, this.name, this.canInteract, this.playerInventoryRanges, this.blockEntityInventoryRanges, null);
        if (!this.objectValues.isEmpty()) {
            built.addObjectSync(this.objectValues);
        }
        if (!this.craftEvents.isEmpty()) {
            built.addCraftEvents(this.craftEvents);
        }
        this.slots.forEach(built::method_7621);
        this.slots.clear();
        return built;
    }

    public BuiltScreenHandler create(MachineBaseBlockEntity blockEntity, int syncID) {
        BuiltScreenHandler built = new BuiltScreenHandler(syncID, this.name, this.canInteract, this.playerInventoryRanges, this.blockEntityInventoryRanges, blockEntity);
        if (!this.objectValues.isEmpty()) {
            built.addObjectSync(this.objectValues);
        }
        if (!this.craftEvents.isEmpty()) {
            built.addCraftEvents(this.craftEvents);
        }
        this.slots.forEach(built::method_7621);
        this.slots.clear();
        return built;
    }
}

