/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.mixin.common;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import reborncore.api.items.ArmorRemoveHandler;
import reborncore.api.items.ArmorTickable;
import reborncore.common.util.ItemUtils;

@Mixin(class_1657.class)
public abstract class MixinPlayerEntity extends class_1309 {

	@Shadow
	public abstract Iterable<class_1799> method_5661();

	protected MixinPlayerEntity(class_1299<? extends class_1309> type, class_1937 world) {
		super(type, world);
	}

	private class_2371<class_1799> reborncore_armorcache = class_2371.method_10213(4, class_1799.field_8037);

	@Inject(method = "tick", at = @At("HEAD"))
	public void tick(CallbackInfo info) {
		int i = 0;
		for (class_1799 stack : method_5661()) {
			class_1799 cachedStack = reborncore_armorcache.get(i);
			if (!ItemUtils.isItemEqual(cachedStack, stack, false, false)) {
				if (cachedStack.method_7909() instanceof ArmorRemoveHandler) {
					((ArmorRemoveHandler) cachedStack.method_7909()).onRemoved((class_1657) (Object) this);
				}
				reborncore_armorcache.set(i, stack.method_7972());
			}
			i++;

			if (!stack.method_7960() && stack.method_7909() instanceof ArmorTickable) {
				((ArmorTickable) stack.method_7909()).tickArmor(stack, (class_1657) (Object) this);
			}
		}
	}
}
