/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.crafting.ingredient;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;

public abstract class RebornIngredient implements Predicate<class_1799> {

	private final class_2960 ingredientType;

	public RebornIngredient(class_2960 ingredientType) {
		this.ingredientType = ingredientType;
	}

	@Override
	public abstract boolean test(class_1799 itemStack);

	public abstract class_1856 getPreview();

	public abstract List<class_1799> getPreviewStacks();

	protected abstract JsonObject toJson();

	public abstract int getCount();

	//Same as above but adds the type
	public final JsonObject witeToJson(){
		JsonObject jsonObject = toJson();
		jsonObject.addProperty("type", ingredientType.toString());
		return jsonObject;
	}

	public <T extends RebornIngredient> void ifType(Class<T> clazz, Consumer<T> consumer){
		if(this.getClass().isAssignableFrom(clazz)){
			//noinspection unchecked
			consumer.accept((T) this);
		}
	}

}
