/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.blocks;

import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import reborncore.api.ToolManager;

import java.util.ArrayList;
import java.util.List;

public class BlockWrenchEventHandler {

	public static List<class_2248> wrenableBlocks = new ArrayList<>();


	public static void setup(){
		UseBlockCallback.EVENT.register((UseBlockCallback) (playerEntity, world, hand, blockHitResult) -> {
			if (hand == class_1268.field_5810) {
				// Wrench should be in main hand
				return class_1269.field_5811;
			}
			if (ToolManager.INSTANCE.canHandleTool(playerEntity.method_5998(class_1268.field_5808))) {
				class_2680 state = world.method_8320(blockHitResult.method_17777());
				if(wrenableBlocks.contains(state.method_26204())){
					class_2248 block = state.method_26204();
					block.method_9534(state, world, blockHitResult.method_17777(), playerEntity, hand, blockHitResult);
					return class_1269.field_5812;
				}
			}
			return class_1269.field_5811;
		});
	}


}
