/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.multiblock;

import reborncore.common.blockentity.MachineBaseBlockEntity;

import java.util.Random;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_827;


public class MultiblockRenderer<T extends MachineBaseBlockEntity> extends class_827<T> {

	private static final class_2338 OUT_OF_WORLD_POS = new class_2338(0, 260, 0); //such a shitty hack to make local lighting not affect this, but it works for now

	public MultiblockRenderer(class_824 blockEntityRenderDispatcher) {
		super(blockEntityRenderDispatcher);
	}

	@Override
	public void render(T blockEntity, float partialTicks, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, int overlay) {
		if (blockEntity.renderMultiblock != null) {
			for (MultiblockComponent comp : blockEntity.renderMultiblock.getComponents()) {
				renderModel(blockEntity, blockEntity.method_10997(), comp.getRelativePosition(), comp.state, matrixStack, vertexConsumerProvider);
			}
		}
	}

	private void renderModel(T blockEntity, class_1937 world, class_2338 relativePos, class_2680 state, class_4587 matrixStack, class_4597 vertexConsumerProvider) {
		final class_2338 blockEntityPos = blockEntity.method_11016();
		final class_776 blockRenderManager = class_310.method_1551().method_1541();
		matrixStack.method_22903();
		matrixStack.method_22904(relativePos.method_10263(), relativePos.method_10264(), relativePos.method_10260());
		matrixStack.method_22904(0.5, 0.5, 0.5);
		float scale = 0.4F;
		matrixStack.method_22905(scale, scale, scale);
		matrixStack.method_22904(-0.5, -0.5, -0.5);

		if (state.method_26204() instanceof class_2404) {
			//TODO nope (edit: nope again on 4-Jan-20)
			//FluidState fluidState = ((FluidBlock) state.getBlock()).getFluidState(state);
			//blockRenderManager.renderFluid(new BlockPos(0, 260, 0), world, vertexConsumerProvider.getBuffer(RenderLayers.getFluidLayer(fluidState)), fluidState);
		} else {
			class_4588 consumer = vertexConsumerProvider.getBuffer(class_1921.method_23577());
			blockRenderManager.method_3355(state, OUT_OF_WORLD_POS, world, matrixStack, consumer, false, new Random());
		}
		matrixStack.method_22909();
	}

}
